﻿// System.WeakObjectHolder`1.cs
// 1.0.*.1

using System.Runtime.CompilerServices;

namespace System
{
    sealed partial class WeakObjectHolder<T> : WeakReference where T : class, new()
    {
        public WeakObjectHolder()
            : base(null)
        {
        }
        public new T Target
        {
            [MethodImpl(MethodImplOptions.Synchronized)]
            get
            {
                Object o;
                if((o = base.Target) == null)
                    base.Target = o = new T();
                return (T)o;
            }
        }
    }
}
